
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : MC56F8006 Modular Pixel Matrix                               *
*  Version    : 0.1                                                          *
*  Date       : 27/Apr/2009                                                  *
*  Engineers  : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: sys.c	                                                             *
*                                                                            *
*    MC56F8006 SYS															 * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#include "util.h"
#include "sys.h"

/********************************* Defines ***********************************/

#define DisableWatchdog()  	\
   SIM_PCE |= SIM_PCE_COP; \
   COP_CTRL &= ~COP_CTRL_CEN; \
   SIM_PCE &= ~SIM_PCE_COP

/******************************** Prototypes *********************************/

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void sys_enable_sci_3x(void)
{
    SIM_PCR |= SIM_PCR_SCI_CR;//Multiply SCI rate by 3
	
}

void sys_init(void)
{
    DisableWatchdog();
    enable_pll();    
	sys_enable_sci_3x();	
}

/*****************************************************************************
* Funcion Name  : InitPorts
* Parameters    : none
* Returns       : none
* Notes         : 
******************************************************************************/

void enable_pll (void)
{	
	uint16_t temp;
	
	// Select prescaler clock (ZSRC=1), power down PLL, enable lock detector
	temp = OCCS_CTRL;	
	temp &= ~OCCS_CTRL_ZSRC;	
	temp |= (OCCS_CTRL_ZSRC_0 | OCCS_CTRL_PLLPD | OCCS_CTRL_LCKON);	
	OCCS_CTRL = temp;
	
	// Power on PLL, wait for lock (LCK0=1), select postscaler clock (ZSRC=2)
	OCCS_CTRL &= ~OCCS_CTRL_PLLPD;
	
    // Loop until OCCS_STAT[LCK0] = 1
    while (!bittest(OCCS_STAT, OCCS_STAT_LCK0)){}
	
	// Set ZSRC bits
    OCCS_CTRL &= ~OCCS_CTRL_ZSRC;	
	OCCS_CTRL |= OCCS_CTRL_ZSRC_1;
}

